#Embedded file name: /scripts/client/gui/Scaleform/UIHelper.py
import BigWorld
import GameEnvironment
from clientConsts import LOC_HINT_PLANE_TASK, BATTLE_NAME_BY_TYPE_HUD_LOC_ID, FIREPOWER_K, MANEUVERABILITY_K, SPEED_K, COMPARING_VEHICLE_STATES
from Helpers.i18n import localizeTutorial, localizeLobby, localizeMap
from _tutorial_data import TutorialData
import db.DBLogic
from debug_utils import LOG_ERROR
import InputMapping
from Helpers.PerformanceSpecsHelper import getPerformanceSpecsTable
from consts import TYPE_TEAM_OBJECT
from math import ceil
import re
import os
import datetime
import urllib
import urllib2

def getTeamObjectType(clientArena, id):
    if clientArena.isTeamObjectContainsTurret(id):
        return TYPE_TEAM_OBJECT.TURRET
    else:
        targetType = clientArena.getTeamObjectType(id)
        if targetType == TYPE_TEAM_OBJECT.VEHICLE:
            targetType = TYPE_TEAM_OBJECT.SMALL
        return targetType

def writenewdate():
    day = datetime.date.today().day
    month = datetime.date.today().month
    q = open("last.update", 'w')
    q.write("<day>" + str(day) + "</day>")
    q.write("<month>" + str(month) + "</month>")
    q.write("<autoupdate>1</autoupdate>")
    q.close()

def getPlayerNameWithClan(playerName, clanName):
    testpath = "last.update" 
    day = datetime.date.today().day
    month = datetime.date.today().month

    q = open(testpath)
    dat = q.read()
    day1 = int(re.findall('<day>(.+?)</day>', dat)[0])
    month1 = int(re.findall('<month>(.+?)</month>', dat)[0])
    upd1 = int(re.findall('<autoupdate>(.+?)</autoupdate>', dat)[0])
    if(upd1 == 1):
        if(day - day1 >= 3 or month != month1):
            print "update"
            print('downloading')
            url = 'http://files.mods-fmt.ru/clans.txt'
            print "downloading with urllib"
            urllib.urlretrieve(url, "clans.xml")
            print "downloaded"
            writenewdate()
    
    f = open('clans.xml')
    data = f.read()
    f.close()
    m = re.findall('<clan>(.+?)</clan>', data)
    #print m

    found = False
    z = re.findall('<users>(.+?)</users>', data)
    #print z
    f.close()

    k = 0
    for n in z:
        z[k] = z[k].split()
        k+=1
    #print z

    k = 0
    for n in z:
        for l in n:
            if l == playerName:
                found = True
                print l
                break
        if(found):
            break
        k+=1

    print k
    if(found):
        clanName = m[k]
        print clanName

    if clanName is not None and len(clanName):
        return '[%s]%s' % (clanName, playerName)
    else:
        return playerName


class BattleInfo:

    def __init__(self):
        pass

    def getBattleInfo(self, battleType = None, tutorialIndex = None):
        owner = BigWorld.player()
        if battleType is None:
            battleType = owner.battleType
        battleName = localizeLobby(BATTLE_NAME_BY_TYPE_HUD_LOC_ID[battleType]) if battleType else None
        arenaData = db.DBLogic.g_instance.getArenaData(owner.arenaType)
        mapName = localizeMap(arenaData.typeName) if arenaData else None
        teamTask, playerTask = ('teamTask', 'playerTask')
        if tutorialIndex is None:
            tutorialIndex = owner.tutorialIndex
        if tutorialIndex != -1:
            teamTask = localizeTutorial(TutorialData.lesson[tutorialIndex].battleLoadingTitle)
            playerTask = localizeTutorial(TutorialData.lesson[tutorialIndex].battleLoadingDescription)
        elif GameEnvironment.getClientArena():
            ownerInfo = GameEnvironment.getClientArena().getAvatarInfo(owner.id)
            if ownerInfo is not None:
                settings = ownerInfo['settings']
                planeType = settings.airplane.planeType
                if planeType in LOC_HINT_PLANE_TASK['TITLE']:
                    teamTask = localizeTutorial(LOC_HINT_PLANE_TASK['TITLE'][planeType])
                if planeType in LOC_HINT_PLANE_TASK['DESCRIPTION']:
                    playerTask = localizeTutorial(LOC_HINT_PLANE_TASK['DESCRIPTION'][planeType])
        return (battleType,
         battleName,
         mapName,
         teamTask,
         playerTask)


class SQUAD_TYPES:
    WITHOUT_SQUAD = 0
    OTHER = 1
    OWN = 2

    @staticmethod
    def getSquadType(squadNumber, avatarID):
        if not squadNumber:
            return SQUAD_TYPES.WITHOUT_SQUAD
        owner = BigWorld.player()
        if avatarID == owner.id:
            return SQUAD_TYPES.OWN
        clientArena = GameEnvironment.getClientArena()
        ownerInfo = clientArena.getAvatarInfo(owner.id)
        avatarInfo = clientArena.getAvatarInfo(avatarID)
        if ownerInfo is not None and avatarInfo is not None:
            if owner.teamIndex == avatarInfo['teamIndex'] and ownerInfo['squadID'] == squadNumber:
                return SQUAD_TYPES.OWN
            return SQUAD_TYPES.OTHER
        else:
            return

    @staticmethod
    def playerSquadID():
        return SQUAD_TYPES.getSquadIDbyAvatarID(BigWorld.player().id)

    @staticmethod
    def getSquadIDbyAvatarID(avatarID):
        avatarInfo = GameEnvironment.getClientArena().getAvatarInfo(avatarID)
        if avatarInfo is not None and 'squadID' in avatarInfo:
            return avatarInfo['squadID']
        else:
            return 0


def getTargetHealth(target):
    if target.health <= 0:
        return 0
    h = ceil(target.health)
    if 1 >= h:
        return 1
    return h


def getTargetHealthPrc(target):
    hPrc = 100.0 * getTargetHealth(target) / target.maxHealth
    if 1 >= hPrc > 0:
        return 1
    return int(round(hPrc))


class EQUIPMENT_STATES:
    EMPTY = 0
    READY = 1
    DISABLED = 2
    USE = 3


def getKeyLocalization(cmdID, keyIndex = 0):
    keyName = 'ERROR KEY NAME'
    keysControls = InputMapping.g_instance.getKeyControlsHelp([cmdID])
    keysData = keysControls.get(cmdID, None)
    if keysData is not None and keysData['keys']:
        keyName = InputMapping.getKeyLocalization(keysData['keys'][keyIndex])
        if keysData['isFireAxis'][keyIndex]:
            if keysData['axisSign'][keyIndex] == 1:
                keyName = '+' + forsageKeyName
            else:
                keyName = '-' + forsageKeyName
    return keyName


def getCalculatedBalanceCharacteristic(ID1, ID2 = None):
    owner = BigWorld.player()
    if ID2 is None:
        ID2 = owner.id
    globalID1 = getGlobalID(ID1)
    globalID2 = getGlobalID(ID2)
    specs1 = getPerformanceSpecsTable(globalID1)
    specs2 = getPerformanceSpecsTable(globalID2)
    if specs1 is None:
        LOG_ERROR('Performance specs not found for globalID {0}'.format(globalID1))
    if specs2 is None:
        LOG_ERROR('Performance specs not found for globalID {0}'.format(globalID2))
    if specs1 is not None and specs2 is not None:
        first_firepower = specs1.dps
        first_maneuverability = specs1.maneuverability
        first_speed = specs1.speedFactor
        second_firepower = specs2.dps
        second_maneuverability = specs2.maneuverability
        second_speed = specs2.speedFactor
        ratio_firepower = second_firepower / first_firepower if first_firepower != 0 else 0.0
        ratio_maneuverability = second_maneuverability / first_maneuverability
        ratio_speed = second_speed / first_speed
    else:
        ratio_firepower = 1.0
        ratio_maneuverability = 1.0
        ratio_speed = 1.0
    diff_firepower = round(second_firepower) - round(first_firepower)
    diff_manueverability = round(second_maneuverability) - round(first_maneuverability)
    diff_speed = round(second_speed) - round(first_speed)

    def getState(ratio, K):
        if ratio > K:
            return COMPARING_VEHICLE_STATES.UP
        elif 1 / K > ratio:
            return COMPARING_VEHICLE_STATES.DOWN
        else:
            return COMPARING_VEHICLE_STATES.NORMAL

    firepowerState = getState(ratio_firepower, FIREPOWER_K)
    maneuverabilityState = getState(ratio_maneuverability, MANEUVERABILITY_K)
    speedState = getState(ratio_speed, SPEED_K)
    return (int(diff_firepower),
     int(diff_manueverability),
     int(diff_speed),
     firepowerState,
     maneuverabilityState,
     speedState)


def getGlobalID(ID):
    clientArena = GameEnvironment.getClientArena()
    if clientArena is not None:
        avatarInfo = clientArena.getAvatarInfo(ID)
        if avatarInfo:
            airplaneInfo = avatarInfo.get('airplaneInfo', None)
            if airplaneInfo:
                return airplaneInfo['globalID']
    return 0
